<?php

namespace app;

use think\Exception;

class Common
{

    /**
     * url参数加密类.
     * [encrypt description]
     * @param  [type] $string    [description]
     * @param  [type] $operation [description]
     * @param  string $key [description]
     * @return [type]            [description]
     */
    public function encrypt($string, $operation, $key = '')
    {
        $key = md5($key);
        $key_length = strlen($key);
        $string = $operation == 'D' ? base64_decode($string) : substr(md5($string . $key), 0, 8) . $string;
        $string_length = strlen($string);
        $rndkey = $box = array();
        $result = '';
        for ($i = 0; $i <= 255; $i++) {
            $rndkey[$i] = ord($key[$i % $key_length]);
            $box[$i] = $i;
        }
        for ($j = $i = 0; $i < 256; $i++) {
            $j = ($j + $box[$i] + $rndkey[$i]) % 256;
            $tmp = $box[$i];
            $box[$i] = $box[$j];
            $box[$j] = $tmp;
        }
        for ($a = $j = $i = 0; $i < $string_length; $i++) {
            $a = ($a + 1) % 256;
            $j = ($j + $box[$a]) % 256;
            $tmp = $box[$a];
            $box[$a] = $box[$j];
            $box[$j] = $tmp;
            $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
        }
        if ($operation == 'D') {
            if (substr($result, 0, 8) == substr(md5(substr($result, 8) . $key), 0, 8)) {
                return substr($result, 8);
            } else {
                return '';
            }
        } else {
            return str_replace('=', '', base64_encode($result));
        }
    }


    /**
     * 判断访问地址是PC和移动方法
     * [is_mobile description]
     * @return boolean [description]
     */
    public function isMobile()
    {
        // 如果有HTTP_X_WAP_PROFILE则一定是移动设备
        if (isset($_SERVER['HTTP_X_WAP_PROFILE'])) {
            return true;
        }
        // 如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
        if (isset($_SERVER['HTTP_VIA'])) {
            // 找不到为flase,否则为true
            return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
        }
        // 脑残法，判断手机发送的客户端标志,兼容性有待提高。其中'MicroMessenger'是电脑微信
        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $clientkeywords = array('nokia', 'sony', 'ericsson', 'mot', 'samsung', 'htc', 'sgh', 'lg', 'sharp', 'sie-', 'philips', 'panasonic', 'alcatel', 'lenovo', 'iphone', 'ipod', 'blackberry', 'meizu', 'android', 'netfront', 'symbian', 'ucweb', 'windowsce', 'palm', 'operamini', 'operamobi', 'openwave', 'nexusone', 'cldc', 'midp', 'wap', 'mobile', 'MicroMessenger');
            // 从HTTP_USER_AGENT中查找手机浏览器的关键字
            if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']))) {
                return true;
            }
        }
        // 协议法，因为有可能不准确，放到最后判断
        if (isset ($_SERVER['HTTP_ACCEPT'])) {
            // 如果只支持wml并且不支持html那一定是移动设备
            // 如果支持wml和html但是wml在html之前则是移动设备
            if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))) {
                return true;
            }
        }
        return false;
    }


    /**
     * 唯一随机数方法
     * [rand description]
     * @param  [type] $len [description]
     * @return [type]      [description]
     */
    public function rand($len)
    {
        $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
        $string = substr(time(), -3);
        for (; $len >= 1; $len--) {
            $position = rand() % strlen($chars);
            $position2 = rand() % strlen($string);
            $string = substr_replace($string, substr($chars, $position, 1), $position2, 0);
        }
        return $string;
    }

    public function dianqilai_access_domain()
    {
        static $domain = null;
        if ($domain) {
            return $domain;
        }
        $file = ROOT_PATH . '/domain.json';
        if (!file_exists($file)) {
            throw new Exception('Domain not found');
        }
        $res = json_decode(file_get_contents($file), true);
        if (!is_array($res)) {
            throw new Exception('Domain cannot be decoded');
        }
        return $version = $res['domain'];
    }

    public function get_tree($data, $pid = 0, $field1 = 'id', $field2 = 'pid', $field3 = 'children')
    {
        $arr = [];
        foreach ($data as $k => $v) {
            if ($v[$field2] == $pid) {
                $v[$field3] = self::get_tree($data, $v[$field1]);
                $arr[] = $v;
            }
        }
        return $arr;
    }

    public function dianqilai_version()
    {
        static $version = null;
        if ($version) {
            return $version;
        }
        $file = ROOT_PATH . '/version.json';
        if (!file_exists($file)) {
            throw new Exception('version not found');
        }
        $res = json_decode(file_get_contents($file), true);
        if (!is_array($res)) {
            throw new Exception('version cannot be decoded');
        }
        return $version = $res['version'];
    }

    public function remove_emoji($nickname)
    {
        // Match Emoticons
        $regexEmoticons = '/[\x{1F600}-\x{1F64F}]/u';
        $clean_text = preg_replace($regexEmoticons, '', $nickname);
        // Match Miscellaneous Symbols and Pictographs
        $regexSymbols = '/[\x{1F300}-\x{1F5FF}]/u';
        $clean_text = preg_replace($regexSymbols, '', $clean_text);
        // Match Transport And Map Symbols
        $regexTransport = '/[\x{1F680}-\x{1F6FF}]/u';
        $clean_text = preg_replace($regexTransport, '', $clean_text);
        // Match Miscellaneous Symbols
        $regexMisc = '/[\x{2600}-\x{26FF}]/u';
        $clean_text = preg_replace($regexMisc, '', $clean_text);
        // Match Dingbats
        $regexDingbats = '/[\x{2700}-\x{27BF}]/u';
        $clean_text = preg_replace($regexDingbats, '', $clean_text);
        return $clean_text;
    }

    //主动判断是否HTTPS
    public function isHTTPS()
    {
        if (defined('HTTPS') && HTTPS) return true;
        if (!isset($_SERVER)) return FALSE;
        if (!isset($_SERVER['HTTPS'])) return FALSE;
        if ($_SERVER['HTTPS'] === 1) {  //Apache
            return TRUE;
        } elseif ($_SERVER['HTTPS'] === 'on') { //IIS
            return TRUE;
        } elseif ($_SERVER['SERVER_PORT'] == 443) { //其他
            return TRUE;
        }
        return FALSE;
    }

    //    自定义函数：快速清除多维维数组的每个元素两边的空格 封装成函数deep_array_map_trim()
    public function deep_array_map_trim($arr)
    {
        return array_map(function (&$v) {
            if (is_array($v)) {
                return $this->deep_array_map_trim($v);
            }
            return trim($v);
        }, $arr);
    }

    //这里是加密函数支持url传输，可用cpDecode()函数解密，$data：待加密的字符串或数组；$key：密钥；$expire 过期时间
    public function cpEncode($data, $key = '', $expire = 0)
    {
        $string = serialize($data);
        $ckey_length = 4;
        $key = md5($key);
        $keya = md5(substr($key, 0, 16));
        $keyb = md5(substr($key, 16, 16));
        $keyc = substr(md5(microtime()), -$ckey_length);

        $cryptkey = $keya . md5($keya . $keyc);
        $key_length = strlen($cryptkey);

        $string = sprintf('%010d', $expire ? $expire + time() : 0) . substr(md5($string . $keyb), 0, 16) . $string;
        $string_length = strlen($string);
        $result = '';
        $box = range(0, 255);

        $rndkey = array();
        for ($i = 0; $i <= 255; $i++) {
            $rndkey[$i] = ord($cryptkey[$i % $key_length]);
        }

        for ($j = $i = 0; $i < 256; $i++) {
            $j = ($j + $box[$i] + $rndkey[$i]) % 256;
            $tmp = $box[$i];
            $box[$i] = $box[$j];
            $box[$j] = $tmp;
        }

        for ($a = $j = $i = 0; $i < $string_length; $i++) {
            $a = ($a + 1) % 256;
            $j = ($j + $box[$a]) % 256;
            $tmp = $box[$a];
            $box[$a] = $box[$j];
            $box[$j] = $tmp;
            $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
        }
        return rawurlencode($keyc . str_replace('=', '', base64_encode($result)));
    }

//cpEncode之后的解密函数，$string待解密的字符串，$key，密钥
    public function cpDecode($string, $key = '')
    {
        $string = rawurldecode($string);
        $ckey_length = 4;
        $key = md5($key);
        $keya = md5(substr($key, 0, 16));
        $keyb = md5(substr($key, 16, 16));
        $keyc = substr($string, 0, $ckey_length);

        $cryptkey = $keya . md5($keya . $keyc);
        $key_length = strlen($cryptkey);

        $string = base64_decode(substr($string, $ckey_length));
        $string_length = strlen($string);

        $result = '';
        $box = range(0, 255);

        $rndkey = array();
        for ($i = 0; $i <= 255; $i++) {
            $rndkey[$i] = ord($cryptkey[$i % $key_length]);
        }

        for ($j = $i = 0; $i < 256; $i++) {
            $j = ($j + $box[$i] + $rndkey[$i]) % 256;
            $tmp = $box[$i];
            $box[$i] = $box[$j];
            $box[$j] = $tmp;
        }

        for ($a = $j = $i = 0; $i < $string_length; $i++) {
            $a = ($a + 1) % 256;
            $j = ($j + $box[$a]) % 256;
            $tmp = $box[$a];
            $box[$a] = $box[$j];
            $box[$j] = $tmp;
            $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
        }
        if ((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26) . $keyb), 0, 16)) {
            return unserialize(substr($result, 26));
        } else {
            return '';
        }
    }

    /* 过滤xss函数 */
    public static function clearXSS($string)
    {
        $config = \HTMLPurifier_HTML5Config::createDefault();
        $config->set('URI.AllowedSchemes', array(
            'http' => true,
            'https' => true,
            'mailto' => true,
            'ftp' => true,
            'nntp' => true,
            'news' => true,
            'tel' => true,
//            重点在这里让它支持data开头协议
            'data' => true
        ));
        $config->set('Attr.AllowedFrameTargets', array('_blank', '_self', '_parent', '_top'));
        $purifier = new \HTMLPurifier($config);
        return $purifier->purify($string);
    }

    /**
     * @param $day
     * @return array
     */
    public static function getDays($day)
    {
        $Days = [];
        $firstDay = date('Y-m-d', time());
        for($i=0;$i<=$day;$i++){
            $Days[] = date('Y-m-d', strtotime("$firstDay -$i day"));
        }
        return $Days;
    }

    /**
     * 获取时间段日期
     * @return array
     */
    public static function getDaysByDay($sday,$eday)
    {
        $days = [];
        $i = 0;
        while (date('Y-m-d', strtotime("$sday +$i days")) <= $eday) {
            $days[] = date('Y-m-d', strtotime("$sday +$i days"));
            $i++;
        }
        return $days;
    }
    public  function generationUrlEncode($data){
        $str = 'theme=' . $data['theme'] . '&visiter_id=' . $data['visiter_id'] . '&visiter_name=' . $data['visiter_name'] . '&avatar=' . $data['avatar'] . '&business_id=' . $data['business_id'] . '&groupid=' . $data['groupid'] . '&product=' . $data['product'] . '&special=' . $data['special'].'&name='.$data['name'];

        $newstr = $this->encrypt($str, 'E', 'QQ290430368');

        return urlencode($newstr);
    }
    public static function getNickName($data){
        $data['visiter_name'] = $data['location'] . '-' .$data['ip'];

        return $data['name'] ?$data['name']:$data['visiter_name'];
    }
}