<?php if (!defined('THINK_PATH')) exit(); /*a:1:{s:79:"/www/wwwroot/cs.wmkf.xyz/public/../application/backend/view/services/index.html";i:1635390980;}*/ ?>

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <link rel="stylesheet" href="/static/component/pear/css/pear.css" />
</head>
<body class="pear-container">
		<div class="layui-card">
			<div class="layui-card-body">
				<form class="layui-form" action="">
					<div class="layui-form-item">
						<div class="layui-form-item layui-inline">
							<label class="layui-form-label">用户名</label>
							<div class="layui-input-inline">
								<input type="text" name="user_name" placeholder="请输入客服用户名" class="layui-input">
							</div>
						</div>
						<div class="layui-form-item layui-inline">
							<button class="pear-btn pear-btn-md pear-btn-primary" lay-submit lay-filter="query">
								<i class="layui-icon layui-icon-search"></i>
								查询
							</button>
							<button type="reset" class="pear-btn pear-btn-md">
								<i class="layui-icon layui-icon-refresh"></i>
								重置
							</button>
						</div>
					</div>
				</form>
			</div>
		</div>
		<div class="layui-card">
			<div class="layui-card-body">
				<table id="dataTable" lay-filter="dataTable"></table>
			</div>
		</div>

		<script type="text/html" id="user-status">
			{{#if (d.state == 'online') { }}
			<span>在线</span>
			{{# }else{ }}
			<span>离线</span>
			{{# } }}
		</script>

		<script type="text/html" id="user-enable">
			<input type="checkbox" name="enable" value="{{d.service_id}}" lay-skin="switch" lay-text="开启|关闭" lay-filter="user-enable" {{ d.offline_first == 1 ? 'checked' : '' }}>
		</script>

		<script type="text/html" id="tool-bar">
			<button class="pear-btn pear-btn-danger pear-btn-xs" lay-event="remove"><i class="layui-icon layui-icon-delete"></i>删除</button>
			<button class="pear-btn pear-btn-xs copy" lay-event="copy" data-clipboard-text="{{d.personal}}"><i class="layui-icon layui-icon-link"></i>复制</button>
			<button class="pear-btn pear-btn-warming pear-btn-xs" lay-event="clear"><i class="layui-icon layui-icon-fonts-clear"></i>清空记录</button>
		</script>

        <script src="/static/component/layui/layui.js"></script>
        <script src="/static/component/pear/pear.js"></script>
		<script src="/assets/js/platform/clipboard.min.js?v=AI_KF"></script>
        <script>
			layui.use(['table', 'form', 'jquery','common'], function() {
				let table = layui.table;
				let form = layui.form;
				let $ = layui.jquery;
				let common = layui.common;

				let MODULE_PATH = "/backend/";

                let cols = [
                        [{
                                field: 'service_id',
                                title: 'ID',
                                unresize: true,
                                align: 'left',
                                width: 80
                            },{
                                field: 'user_name',
                                title: '用户名',
                                unresize: true,
                                align: 'left'
                            }, {
                                field: 'nick_name',
                                title: '昵称',
                                unresize: true,
                                align: 'left',
                            },  {
                                field: 'business_name',
                                title: '所属商户',
                                unresize: true,
                                align: 'left',
                            },
                            {
                                field: 'state',
                                title: '在线状态',
                                unresize: true,
                                align: 'left',
                                templet: '#user-status'
                            },
                            {
                                title: '操作',
                                toolbar: '#tool-bar',
                                align: 'center',
                                width: 300
                            }
                        ]
                    ];

				table.render({
					elem: '#dataTable',
					url: MODULE_PATH + 'services/index',
					page: true,
					cols: cols,
                    cellMinWidth: 100,
					skin: 'line',
					toolbar: '#toolbar',
					defaultToolbar: [{
						title: '刷新',
						layEvent: 'refresh',
						icon: 'layui-icon-refresh',
					}, 'filter', 'print', 'exports']
				});

				table.on('toolbar(dataTable)', function(obj) {
					if (obj.event === 'refresh') {
						window.refresh();
					}
				});

                table.on('tool(dataTable)', function(obj) {
					if (obj.event === 'copy') {
                        window.copy(obj);
                    }else if (obj.event === 'remove') {
                        window.remove(obj);
                    }else if (obj.event === 'clear') {
                        window.clear(obj);
                    }
                });

                form.on('submit(query)', function(data) {
                    table.reload('dataTable', {
                        where: data.field,
                        page:{curr: 1}
                    });
                    return false;
                });

                window.copy = function(obj) {
                    var clipboard = new ClipboardJS('.copy');
                    clipboard.on('success', function(e) {
                        layer.msg('复制客服链接成功', {icon: 1});
                        e.clearSelection();
                    });
                    clipboard.on('error', function(e) {
                        layer.msg('复制成功，请关闭兼容模式或者升级浏览器');
                    });
				};

                window.remove = function(obj) {
                    layer.confirm('确定要删除该用户', {
                        icon: 3,
                        title: '提示'
                    }, function(index) {
                        layer.close(index);
                        let loading = layer.load();
                        $.ajax({
                            url: MODULE_PATH + "services/remove?service_id="+obj.data.service_id,
                            dataType: 'json',
                            type: 'delete',
                            success: function(result) {
                                layer.close(loading);
                                if (result.code === 1) {
                                    layer.msg(result.msg, {
                                        icon: 1,
                                        time: 1000
                                    }, function() {
                                        obj.del();
                                    });
                                } else {
                                    layer.msg(result.msg, {
                                        icon: 2,
                                        time: 1000
                                    });
                                }
                            }
                        })
                    });
                };

                window.clear = function(obj) {
                    layer.confirm('确定要清空该客服的所有聊天记录吗？', {
                        icon: 3,
                        title: '提示'
                    }, function(index) {
                        layer.close(index);
                        let loading = layer.load();
                        $.ajax({
                            url: MODULE_PATH + "services/clear?id="+obj.data.service_id,
                            dataType: 'json',
                            type: 'delete',
                            success: function(result) {
                                layer.close(loading);
                                if (result.code === 1) {
                                    layer.msg(result.msg, {
                                        icon: 1,
                                        time: 1000
                                    });
                                } else {
                                    layer.msg(result.msg, {
                                        icon: 2,
                                        time: 1000
                                    });
                                }
                            }
                        })
                    });
                };
                
				window.refresh = function(param) {
					table.reload('dataTable');
				}
			})
		</script>
</body>
</html>
